/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.parser.internal;

import icyllis.annotations.NotNull;
import icyllis.annotations.Nullable;
import icyllis.flexmark.ast.AutoLink;
import icyllis.flexmark.ast.Code;
import icyllis.flexmark.ast.HardLineBreak;
import icyllis.flexmark.ast.HtmlEntity;
import icyllis.flexmark.ast.HtmlInline;
import icyllis.flexmark.ast.HtmlInlineBase;
import icyllis.flexmark.ast.HtmlInlineComment;
import icyllis.flexmark.ast.Image;
import icyllis.flexmark.ast.ImageRef;
import icyllis.flexmark.ast.InlineLinkNode;
import icyllis.flexmark.ast.Link;
import icyllis.flexmark.ast.LinkRef;
import icyllis.flexmark.ast.LinkRefDerived;
import icyllis.flexmark.ast.LinkRendered;
import icyllis.flexmark.ast.MailLink;
import icyllis.flexmark.ast.Paragraph;
import icyllis.flexmark.ast.RefNode;
import icyllis.flexmark.ast.Reference;
import icyllis.flexmark.ast.SoftLineBreak;
import icyllis.flexmark.ast.Text;
import icyllis.flexmark.ast.WhiteSpace;
import icyllis.flexmark.ast.util.ReferenceRepository;
import icyllis.flexmark.ast.util.TextNodeConverter;
import icyllis.flexmark.parser.InlineParser;
import icyllis.flexmark.parser.InlineParserExtension;
import icyllis.flexmark.parser.InlineParserExtensionFactory;
import icyllis.flexmark.parser.LightInlineParserImpl;
import icyllis.flexmark.parser.LinkRefProcessor;
import icyllis.flexmark.parser.LinkRefProcessorFactory;
import icyllis.flexmark.parser.Parser;
import icyllis.flexmark.parser.block.CharacterNodeFactory;
import icyllis.flexmark.parser.block.ParagraphPreProcessor;
import icyllis.flexmark.parser.block.ParserState;
import icyllis.flexmark.parser.core.delimiter.AsteriskDelimiterProcessor;
import icyllis.flexmark.parser.core.delimiter.Bracket;
import icyllis.flexmark.parser.core.delimiter.Delimiter;
import icyllis.flexmark.parser.core.delimiter.UnderscoreDelimiterProcessor;
import icyllis.flexmark.parser.delimiter.DelimiterProcessor;
import icyllis.flexmark.parser.internal.LinkDestinationParser;
import icyllis.flexmark.parser.internal.LinkRefProcessorData;
import icyllis.flexmark.util.ast.Block;
import icyllis.flexmark.util.ast.DoNotDecorate;
import icyllis.flexmark.util.ast.DoNotTrim;
import icyllis.flexmark.util.ast.Document;
import icyllis.flexmark.util.ast.Node;
import icyllis.flexmark.util.data.DataHolder;
import icyllis.flexmark.util.dependency.DependencyResolver;
import icyllis.flexmark.util.misc.CharPredicate;
import icyllis.flexmark.util.sequence.BasedSequence;
import icyllis.flexmark.util.sequence.Escaping;
import icyllis.flexmark.util.sequence.SegmentedSequence;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;

public class InlineParserImpl
extends LightInlineParserImpl
implements InlineParser,
ParagraphPreProcessor {
    protected final BitSet originalSpecialCharacters;
    protected final BitSet delimiterCharacters;
    protected final Map<Character, DelimiterProcessor> delimiterProcessors;
    protected final LinkRefProcessorData linkRefProcessorsData;
    protected List<LinkRefProcessor> linkRefProcessors = null;
    protected Map<Character, List<InlineParserExtension>> inlineParserExtensions = null;
    protected List<InlineParserExtensionFactory> inlineParserExtensionFactories = null;
    protected LinkDestinationParser linkDestinationParser = null;
    protected BitSet specialCharacters;
    protected BitSet customCharacters = null;
    protected Map<Character, CharacterNodeFactory> customSpecialCharacterFactoryMap = null;
    protected ArrayList<Node> customSpecialCharacterNodes = null;
    protected ReferenceRepository referenceRepository;
    protected Delimiter lastDelimiter;
    private Bracket lastBracket;

    public InlineParserImpl(DataHolder options, BitSet specialCharacters, BitSet delimiterCharacters, Map<Character, DelimiterProcessor> delimiterProcessors, LinkRefProcessorData linkRefProcessorsData, List<InlineParserExtensionFactory> inlineParserExtensionFactories) {
        super(options);
        this.delimiterProcessors = delimiterProcessors;
        this.linkRefProcessorsData = linkRefProcessorsData;
        this.delimiterCharacters = delimiterCharacters;
        this.originalSpecialCharacters = specialCharacters;
        this.specialCharacters = specialCharacters;
        List<InlineParserExtensionFactory> list = this.inlineParserExtensionFactories = !inlineParserExtensionFactories.isEmpty() ? inlineParserExtensionFactories : null;
        if (this.options.useHardcodedLinkAddressParser) {
            this.linkDestinationParser = new LinkDestinationParser(this.options.linksAllowMatchedParentheses, this.options.spaceInLinkUrls, this.options.parseJekyllMacrosInUrls, this.options.intellijDummyIdentifier);
        }
    }

    @Override
    public void initializeDocument(@NotNull Document document) {
        this.document = document;
        this.referenceRepository = Parser.REFERENCES.get(document);
        this.linkRefProcessors = new ArrayList<LinkRefProcessor>(this.linkRefProcessorsData.processors.size());
        for (LinkRefProcessorFactory factory : this.linkRefProcessorsData.processors) {
            this.linkRefProcessors.add(factory.apply(document));
        }
        if (this.inlineParserExtensionFactories != null) {
            Map<Character, List<InlineParserExtensionFactory>> extensions = InlineParserImpl.calculateInlineParserExtensions(document, this.inlineParserExtensionFactories);
            this.inlineParserExtensions = new HashMap<Character, List<InlineParserExtension>>(extensions.size());
            HashMap<InlineParserExtensionFactory, InlineParserExtension> parserExtensionMap = new HashMap<InlineParserExtensionFactory, InlineParserExtension>();
            for (Map.Entry<Character, List<InlineParserExtensionFactory>> entry : extensions.entrySet()) {
                ArrayList<InlineParserExtension> extensionList = new ArrayList<InlineParserExtension>(entry.getValue().size());
                for (InlineParserExtensionFactory factory : entry.getValue()) {
                    InlineParserExtension parserExtension = (InlineParserExtension)parserExtensionMap.get(factory);
                    if (parserExtension == null) {
                        parserExtension = factory.apply(this);
                        parserExtensionMap.put(factory, parserExtension);
                    }
                    extensionList.add(parserExtension);
                }
                this.inlineParserExtensions.put(entry.getKey(), extensionList);
                this.specialCharacters.set(entry.getKey().charValue());
            }
        }
    }

    @Override
    public void finalizeDocument(@NotNull Document document) {
        assert (this.referenceRepository == Parser.REFERENCES.get(document));
        if (this.inlineParserExtensions != null) {
            for (List<InlineParserExtension> extensionList : this.inlineParserExtensions.values()) {
                for (InlineParserExtension extension : extensionList) {
                    extension.finalizeDocument(this);
                }
            }
        }
    }

    @Override
    public Delimiter getLastDelimiter() {
        return this.lastDelimiter;
    }

    @Override
    public Bracket getLastBracket() {
        return this.lastBracket;
    }

    @Override
    @Nullable
    public List<Node> parseCustom(@NotNull BasedSequence input, @NotNull Node node, @NotNull BitSet customCharacters, @NotNull Map<Character, CharacterNodeFactory> nodeFactoryMap) {
        this.customCharacters = customCharacters;
        this.specialCharacters.or(customCharacters);
        this.customSpecialCharacterFactoryMap = nodeFactoryMap;
        this.customSpecialCharacterNodes = null;
        this.parse(input, node);
        this.specialCharacters = this.originalSpecialCharacters;
        this.customSpecialCharacterFactoryMap = null;
        this.customCharacters = null;
        return this.customSpecialCharacterNodes;
    }

    @Override
    public void parse(@NotNull BasedSequence content, @NotNull Node block) {
        boolean moreToParse;
        this.block = block;
        this.input = (BasedSequence)content.trim();
        this.index = 0;
        this.lastDelimiter = null;
        this.lastBracket = null;
        boolean customOnly = block instanceof DoNotDecorate;
        while (moreToParse = this.parseInline(customOnly)) {
        }
        this.processDelimiters(null);
        this.flushTextNode();
        if (!customOnly && this.inlineParserExtensions != null) {
            for (List<InlineParserExtension> extensionList : this.inlineParserExtensions.values()) {
                for (InlineParserExtension extension : extensionList) {
                    extension.finalizeBlock(this);
                }
            }
        }
        this.mergeTextNodes(block.getFirstChild(), block.getLastChild());
    }

    @Override
    public void mergeTextNodes(@Nullable Node fromNode, @Nullable Node toNode) {
        Text first = null;
        Text last = null;
        for (Node node = fromNode; node != null; node = node.getNext()) {
            if (node instanceof Text) {
                Text text = (Text)node;
                if (first == null) {
                    first = text;
                }
                last = text;
            } else {
                this.mergeIfNeeded(first, last);
                first = null;
                last = null;
            }
            if (node == toNode) break;
        }
        this.mergeIfNeeded(first, last);
    }

    @Override
    public void mergeIfNeeded(Text first, Text last) {
        if (first != null && last != null && first != last) {
            ArrayList<BasedSequence> sb = new ArrayList<BasedSequence>();
            sb.add(first.getChars());
            Node stop = last.getNext();
            for (Node node = first.getNext(); node != stop; node = node.getNext()) {
                sb.add(node.getChars());
                Node unlink = node;
                unlink.unlink();
            }
            BasedSequence literal = SegmentedSequence.create(first.getChars(), sb);
            first.setChars(literal);
        }
    }

    @Override
    public int preProcessBlock(Paragraph block, ParserState state) {
        BasedSequence contentChars = block.getChars();
        int leadingSpaces = contentChars.countLeading(CharPredicate.SPACE_TAB);
        int length = contentChars.length();
        while (leadingSpaces <= 3 && length > 3 + leadingSpaces && contentChars.charAt(leadingSpaces) == '[') {
            int pos;
            if (leadingSpaces > 0) {
                contentChars = contentChars.subSequence(leadingSpaces, length);
                length -= leadingSpaces;
            }
            if ((pos = this.parseReference(block, contentChars)) == 0) break;
            contentChars = contentChars.subSequence(pos, length);
            length = contentChars.length();
            leadingSpaces = contentChars.countLeading(CharPredicate.SPACE_TAB);
        }
        return contentChars.getStartOffset() - block.getStartOffset();
    }

    protected int parseReference(Block block, BasedSequence s2) {
        this.input = s2;
        this.index = 0;
        int startIndex = this.index++;
        int matchChars = this.parseLinkLabel();
        if (matchChars == 0) {
            return 0;
        }
        if (this.peek() != ':') {
            return 0;
        }
        BasedSequence rawLabel = this.input.subSequence(0, matchChars + 1);
        this.spnl();
        BasedSequence dest = this.parseLinkDestination();
        if (dest == null || dest.length() == 0) {
            return 0;
        }
        int beforeTitle = this.index;
        this.spnl();
        BasedSequence title = this.parseLinkTitle();
        if (title == null) {
            this.index = beforeTitle;
        }
        boolean atLineEnd = true;
        if (this.index != this.input.length() && this.match(this.myParsing.LINE_END) == null) {
            if (title == null) {
                atLineEnd = false;
            } else {
                title = null;
                this.index = beforeTitle;
                boolean bl = atLineEnd = this.match(this.myParsing.LINE_END) != null;
            }
        }
        if (!atLineEnd) {
            return 0;
        }
        String normalizedLabel = Escaping.normalizeReferenceChars(rawLabel, true);
        if (normalizedLabel.isEmpty()) {
            return 0;
        }
        Reference reference = new Reference(rawLabel, dest, title);
        this.referenceRepository.put(normalizedLabel, reference);
        block.insertBefore(reference);
        return this.index - startIndex;
    }

    protected boolean parseInline() {
        return this.parseInline(false);
    }

    protected boolean parseInline(boolean customOnly) {
        List<InlineParserExtension> extensions;
        boolean res = false;
        char c = this.peek();
        if (c == '\u0000') {
            return false;
        }
        if (!customOnly && this.inlineParserExtensions != null && (extensions = this.inlineParserExtensions.get(Character.valueOf(c))) != null) {
            for (InlineParserExtension extension : extensions) {
                res = extension.parse(this);
                if (!res) continue;
                return true;
            }
        }
        if (this.customCharacters != null && this.customCharacters.get(c)) {
            res = this.processCustomCharacters();
            if (!res) {
                ++this.index;
                this.appendText(this.input.subSequence(this.index - 1, this.index));
            } else {
                this.processDelimiters(null);
                this.lastDelimiter = null;
            }
            return true;
        }
        switch (c) {
            case '\n': 
            case '\r': {
                res = this.parseNewline();
                break;
            }
            case '\\': {
                res = this.parseBackslash();
                break;
            }
            case '`': {
                res = this.parseBackticks();
                break;
            }
            case '[': {
                res = this.parseOpenBracket();
                break;
            }
            case '!': {
                res = this.parseBang();
                break;
            }
            case ']': {
                res = this.parseCloseBracket();
                break;
            }
            case '<': {
                DelimiterProcessor delimiterProcessor;
                boolean isDelimiter = this.delimiterCharacters.get(c);
                if (isDelimiter && this.peek(1) == '<') {
                    delimiterProcessor = this.delimiterProcessors.get(Character.valueOf(c));
                    res = this.parseDelimiters(delimiterProcessor, c);
                    break;
                }
                res = this.parseAutolink() || this.parseHtmlInline();
                break;
            }
            case '&': {
                res = this.parseEntity();
                break;
            }
            default: {
                DelimiterProcessor delimiterProcessor;
                boolean isDelimiter = this.delimiterCharacters.get(c);
                if (isDelimiter) {
                    delimiterProcessor = this.delimiterProcessors.get(Character.valueOf(c));
                    res = this.parseDelimiters(delimiterProcessor, c);
                    break;
                }
                res = this.parseString();
            }
        }
        if (!res) {
            ++this.index;
            this.appendText(this.input.subSequence(this.index - 1, this.index));
        }
        return true;
    }

    private boolean processCustomCharacters() {
        char c = this.peek();
        CharacterNodeFactory factory = this.customSpecialCharacterFactoryMap.get(Character.valueOf(c));
        if (factory == null) {
            return false;
        }
        Node node = (Node)factory.get();
        node.setChars(this.input.subSequence(this.index, this.index + 1));
        if (this.currentText != null) {
            int pos;
            BasedSequence prevText = SegmentedSequence.create(node.getChars(), this.currentText);
            this.currentText = null;
            BasedSequence skipped = null;
            for (pos = prevText.length(); pos > 0 && factory.skipPrev(prevText.charAt(pos - 1)); --pos) {
            }
            if (pos < prevText.length()) {
                skipped = (BasedSequence)prevText.subSequence(pos);
                prevText = prevText.subSequence(0, pos);
            }
            this.block.appendChild(new Text(prevText));
            if (skipped != null && factory.wantSkippedWhitespace()) {
                this.block.appendChild(new WhiteSpace(skipped));
            }
        }
        this.appendNode(node);
        if (this.customSpecialCharacterNodes == null) {
            this.customSpecialCharacterNodes = new ArrayList();
        }
        this.customSpecialCharacterNodes.add(node);
        int pos = this.index + 1;
        do {
            ++this.index;
        } while ((c = this.peek()) != '\u0000' && factory.skipNext(c));
        if (pos < this.index && factory.wantSkippedWhitespace()) {
            this.block.appendChild(new WhiteSpace(this.input.subSequence(pos, this.index)));
        }
        return true;
    }

    @Override
    public boolean parseNewline() {
        boolean crLf = this.index < this.input.length() - 1 && this.input.charAt(this.index + 1) == '\n';
        int crLfDelta = crLf ? 1 : 0;
        this.index += 1 + crLfDelta;
        this.flushTextNode();
        Node lastChild = this.block.getLastChild();
        if (lastChild instanceof Text && lastChild.getChars().endsWith(" ")) {
            int spaces;
            Text text = (Text)lastChild;
            BasedSequence literal = text.getChars();
            Matcher matcher = this.myParsing.FINAL_SPACE.matcher(literal);
            int n = spaces = matcher.find() ? matcher.end() - matcher.start() : 0;
            this.appendNode(spaces >= 2 ? new HardLineBreak(this.input.subSequence(this.index - (this.options.hardLineBreakLimit ? 3 + crLfDelta : spaces + 1 + crLfDelta), this.index)) : new SoftLineBreak(this.input.subSequence(this.index - 1 - crLfDelta, this.index)));
            if (spaces > 0) {
                if (literal.length() > spaces) {
                    lastChild.setChars((BasedSequence)literal.subSequence(0, literal.length() - spaces).trimEnd());
                } else {
                    lastChild.unlink();
                }
            }
        } else {
            this.appendNode(new SoftLineBreak(this.input.subSequence(this.index - 1 - crLfDelta, this.index)));
        }
        while (this.peek() == ' ') {
            ++this.index;
        }
        return true;
    }

    protected boolean parseBackslash() {
        ++this.index;
        if (this.peek() == '\n' || this.peek() == '\r') {
            int charsMatched = this.peek(1) == '\n' ? 2 : 1;
            this.appendNode(new HardLineBreak(this.input.subSequence(this.index - 1, this.index + charsMatched)));
            this.index += charsMatched;
        } else if (this.index < this.input.length() && this.myParsing.ESCAPABLE.matcher(this.input.subSequence(this.index, this.index + 1)).matches()) {
            this.appendText(this.input, this.index - 1, this.index + 1);
            ++this.index;
        } else {
            this.appendText(this.input.subSequence(this.index - 1, this.index));
        }
        return true;
    }

    protected boolean parseBackticks() {
        BasedSequence matched;
        BasedSequence ticks = this.match(this.myParsing.TICKS_HERE);
        if (ticks == null) {
            return false;
        }
        int afterOpenTicks = this.index;
        while ((matched = this.match(this.myParsing.TICKS)) != null) {
            if (!matched.equals(ticks)) continue;
            int ticksLength = ticks.length();
            BasedSequence codeText = this.input.subSequence(afterOpenTicks, this.index - ticksLength);
            Code node = new Code(this.input.subSequence(afterOpenTicks - ticksLength, afterOpenTicks), codeText, this.input.subSequence(this.index - ticksLength, this.index));
            if (this.options.codeSoftLineBreaks) {
                int length = codeText.length();
                int lastPos = 0;
                while (lastPos < length) {
                    int softBreak = codeText.indexOfAny(CharPredicate.ANY_EOL, lastPos);
                    int pos = softBreak == -1 ? length : softBreak;
                    Text textNode = new Text(codeText.subSequence(lastPos, pos));
                    node.appendChild(textNode);
                    lastPos = pos;
                    if (lastPos >= length) break;
                    if (codeText.charAt(lastPos) == '\r') {
                        if (++lastPos >= length) break;
                        if (codeText.charAt(lastPos) == '\n') {
                            ++lastPos;
                        }
                    } else {
                        ++lastPos;
                    }
                    if (lastPos < length) {
                        if (pos >= lastPos) continue;
                        SoftLineBreak softLineBreak = new SoftLineBreak(codeText.subSequence(softBreak, lastPos));
                        node.appendChild(softLineBreak);
                        continue;
                    }
                    break;
                }
            } else {
                Text textNode = new Text(codeText);
                node.appendChild(textNode);
            }
            this.appendNode(node);
            return true;
        }
        this.index = afterOpenTicks;
        this.appendText(ticks);
        return true;
    }

    protected boolean parseDelimiters(DelimiterProcessor delimiterProcessor, char delimiterChar) {
        DelimiterData res = this.scanDelimiters(delimiterProcessor, delimiterChar);
        if (res == null) {
            return false;
        }
        int numDelims = res.count;
        int startIndex = this.index;
        this.index += numDelims;
        Text node = this.appendSeparateText(this.input.subSequence(startIndex, this.index));
        this.lastDelimiter = new Delimiter(this.input, node, delimiterChar, res.canOpen, res.canClose, this.lastDelimiter, startIndex);
        this.lastDelimiter.setNumDelims(numDelims);
        if (this.lastDelimiter.getPrevious() != null) {
            this.lastDelimiter.getPrevious().setNext(this.lastDelimiter);
        }
        return true;
    }

    protected boolean parseOpenBracket() {
        int startIndex = this.index++;
        Text node = this.appendSeparateText(this.input.subSequence(this.index - 1, this.index));
        this.addBracket(Bracket.link(this.input, node, startIndex, this.lastBracket, this.lastDelimiter));
        return true;
    }

    protected boolean parseBang() {
        int startIndex = this.index++;
        if (this.peek() == '[') {
            ++this.index;
            Text node = this.appendSeparateText(this.input.subSequence(this.index - 2, this.index));
            this.addBracket(Bracket.image(this.input, node, startIndex + 1, this.lastBracket, this.lastDelimiter));
        } else {
            this.appendText(this.input.subSequence(this.index - 1, this.index));
        }
        return true;
    }

    private void addBracket(Bracket bracket) {
        if (this.lastBracket != null) {
            this.lastBracket.setBracketAfter(true);
        }
        this.lastBracket = bracket;
    }

    private void removeLastBracket() {
        this.lastBracket = this.lastBracket.getPrevious();
    }

    private ReferenceProcessorMatch matchLinkRef(Bracket opener, int startIndex, int lookAhead, int nesting) {
        int startProc;
        LinkRefProcessor linkProcessor;
        if (this.linkRefProcessorsData.nestingIndex.length == 0) {
            return null;
        }
        ReferenceProcessorMatch match = null;
        BasedSequence textNoBang = null;
        BasedSequence textWithBang = null;
        int iMax = this.linkRefProcessorsData.processors.size();
        for (int i = startProc = this.linkRefProcessorsData.nestingIndex[lookAhead + nesting]; i < iMax && lookAhead + nesting >= (linkProcessor = this.linkRefProcessors.get(i)).getBracketNestingLevel(); ++i) {
            BasedSequence nodeChars;
            boolean wantBang = linkProcessor.getWantExclamationPrefix();
            if (opener.isImage() && wantBang) {
                if (textWithBang == null) {
                    textWithBang = this.input.subSequence(opener.getStartIndex() - 1 - lookAhead, startIndex + lookAhead);
                }
                nodeChars = textWithBang;
            } else if (wantBang && opener.getStartIndex() >= lookAhead + 1 && this.input.charAt(opener.getStartIndex() - 1 - lookAhead) == '!') {
                if (textWithBang == null) {
                    textWithBang = this.input.subSequence(opener.getStartIndex() - 1 - lookAhead, startIndex + lookAhead);
                }
                nodeChars = textWithBang;
            } else {
                if (textNoBang == null) {
                    textNoBang = this.input.subSequence(opener.getStartIndex() - lookAhead, startIndex + lookAhead);
                }
                nodeChars = textNoBang;
            }
            if (!linkProcessor.isMatch(nodeChars)) continue;
            match = new ReferenceProcessorMatch(linkProcessor, wantBang, nodeChars);
            break;
        }
        return match;
    }

    protected boolean parseCloseBracket() {
        ++this.index;
        int startIndex = this.index;
        Bracket opener = this.lastBracket;
        if (opener == null) {
            this.appendText(this.input.subSequence(this.index - 1, this.index));
            return true;
        }
        if (!opener.isAllowed()) {
            this.appendText(this.input.subSequence(this.index - 1, this.index));
            this.removeLastBracket();
            return true;
        }
        int nestedBrackets = 0;
        BasedSequence dest = null;
        BasedSequence title = null;
        BasedSequence ref = null;
        boolean isLinkOrImage = false;
        boolean refIsBare = false;
        ReferenceProcessorMatch linkRefProcessorMatch = null;
        boolean refIsDefined = false;
        BasedSequence linkOpener = BasedSequence.NULL;
        BasedSequence linkCloser = BasedSequence.NULL;
        BasedSequence bareRef = BasedSequence.NULL;
        BasedSequence imageUrlContent = null;
        int preSpaceIndex = this.index;
        if (this.options.spaceInLinkElements && this.peek() == ' ') {
            this.sp();
        }
        if (this.peek() == '(') {
            int savedIndex = this.index;
            linkOpener = this.input.subSequence(this.index, this.index + 1);
            ++this.index;
            this.spnl();
            dest = this.parseLinkDestination();
            if (dest != null) {
                if (this.options.parseMultiLineImageUrls && opener.isImage() && !dest.startsWith("<") && dest.endsWith("?") && this.spnlUrl()) {
                    int contentStart;
                    int contentEnd = contentStart = this.index;
                    while (true) {
                        this.sp();
                        BasedSequence multiLineTitle = this.parseLinkTitle();
                        if (multiLineTitle != null) {
                            this.sp();
                        }
                        if (this.peek() == ')') {
                            linkCloser = this.input.subSequence(this.index, this.index + 1);
                            ++this.index;
                            imageUrlContent = this.input.subSequence(contentStart, contentEnd);
                            title = multiLineTitle;
                            isLinkOrImage = true;
                        } else {
                            BasedSequence restOfLine = this.toEOL();
                            if (restOfLine != null) {
                                contentEnd = this.index;
                                continue;
                            }
                        }
                        break;
                    }
                } else {
                    this.spnl();
                    if (this.myParsing.WHITESPACE.matcher(this.input.subSequence(this.index - 1, this.index)).matches()) {
                        title = this.parseLinkTitle();
                        this.spnl();
                    }
                    if (this.peek() == ')') {
                        linkCloser = this.input.subSequence(this.index, this.index + 1);
                        ++this.index;
                        isLinkOrImage = true;
                    } else {
                        this.index = savedIndex;
                    }
                }
            } else {
                this.index = savedIndex;
            }
        } else {
            this.index = preSpaceIndex;
        }
        if (!isLinkOrImage) {
            if (!this.options.matchLookaheadFirst) {
                linkRefProcessorMatch = this.matchLinkRef(opener, startIndex, 0, nestedBrackets);
            }
            if (linkRefProcessorMatch == null) {
                int maxWanted = this.linkRefProcessorsData.maxNesting;
                int maxAvail = 0;
                if (maxWanted > nestedBrackets) {
                    Bracket nested = opener;
                    while (nested.getPrevious() != null && nested.getStartIndex() == nested.getPrevious().getStartIndex() + 1 && this.peek(maxAvail) == ']') {
                        nested = nested.getPrevious();
                        if (++maxAvail + nestedBrackets != maxWanted && !nested.isImage()) continue;
                    }
                }
                int nesting = maxAvail + 1;
                while (nesting-- > 0) {
                    linkRefProcessorMatch = this.matchLinkRef(opener, startIndex, nesting, nestedBrackets);
                    if (linkRefProcessorMatch == null) continue;
                    if (nesting <= 0) break;
                    while (nesting-- > 0) {
                        ++this.index;
                        this.lastBracket.getNode().unlink();
                        this.removeLastBracket();
                    }
                    opener = this.lastBracket;
                    break;
                }
            }
            if (linkRefProcessorMatch == null) {
                int beforeLabel = this.index;
                int labelLength = this.parseLinkLabel();
                if (labelLength > 2) {
                    ref = this.input.subSequence(beforeLabel, beforeLabel + labelLength);
                } else if (!opener.isBracketAfter()) {
                    bareRef = this.input.subSequence(beforeLabel, beforeLabel + labelLength);
                    ref = opener.isImage() ? this.input.subSequence(opener.getStartIndex() - 1, startIndex) : this.input.subSequence(opener.getStartIndex(), startIndex);
                    refIsBare = true;
                }
                if (ref != null) {
                    String normalizedLabel = Escaping.normalizeReferenceChars(ref, true);
                    if (this.referenceRepository.containsKey(normalizedLabel)) {
                        BasedSequence sequence = this.input.subSequence(opener.getStartIndex(), startIndex);
                        boolean containsLinks = InlineParserImpl.containsLinkRefs(refIsBare ? ref : sequence, opener.getNode().getNext(), false);
                        isLinkOrImage = !containsLinks;
                        refIsDefined = true;
                    } else if (!opener.isStraddling(ref)) {
                        if (!refIsBare && this.peek() == '[') {
                            int nextLength = this.parseLinkLabel();
                            if (nextLength > 0) {
                                this.index = beforeLabel;
                            } else {
                                boolean containsLinks = InlineParserImpl.containsLinkRefs(ref, opener.getNode().getNext(), null);
                                if (!containsLinks) {
                                    refIsBare = true;
                                    isLinkOrImage = true;
                                }
                            }
                        } else {
                            boolean containsLinks = InlineParserImpl.containsLinkRefs(ref, opener.getNode().getNext(), null);
                            if (!containsLinks) {
                                isLinkOrImage = true;
                            }
                        }
                    }
                }
            }
        }
        if (isLinkOrImage || linkRefProcessorMatch != null) {
            Node insertNode;
            this.flushTextNode();
            boolean isImage = opener.isImage();
            if (linkRefProcessorMatch != null) {
                if (!linkRefProcessorMatch.wantExclamation && isImage) {
                    this.appendText(this.input.subSequence(opener.getStartIndex() - 1, opener.getStartIndex()));
                    opener.getNode().setChars((BasedSequence)opener.getNode().getChars().subSequence(1));
                    isImage = false;
                }
                insertNode = linkRefProcessorMatch.processor.createNode(linkRefProcessorMatch.nodeChars);
            } else {
                insertNode = ref != null ? (isImage ? new ImageRef() : new LinkRef()) : (isImage ? new Image() : new Link());
            }
            Node node = opener.getNode().getNext();
            while (node != null) {
                Node next = node.getNext();
                insertNode.appendChild(node);
                node = next;
            }
            if (linkRefProcessorMatch != null && insertNode.hasChildren()) {
                BasedSequence original = insertNode.getChildChars();
                BasedSequence text = linkRefProcessorMatch.processor.adjustInlineText(this.document, insertNode);
                Delimiter delimiter = this.lastDelimiter;
                while (delimiter != null) {
                    Delimiter prevDelimiter = delimiter.getPrevious();
                    BasedSequence delimiterChars = delimiter.getInput().subSequence(delimiter.getStartIndex(), delimiter.getEndIndex());
                    if (!(!original.containsAllOf(delimiterChars) || text.containsAllOf(delimiterChars) && linkRefProcessorMatch.processor.allowDelimiters(delimiterChars, this.document, insertNode))) {
                        this.removeDelimiterKeepNode(delimiter);
                    }
                    delimiter = prevDelimiter;
                }
                if (!text.containsAllOf(original)) {
                    for (Node node2 : insertNode.getChildren()) {
                        BasedSequence nodeChars = node2.getChars();
                        if (text.containsSomeOf(nodeChars)) {
                            if (text.containsAllOf(nodeChars)) continue;
                            BasedSequence chars = text.intersect(nodeChars);
                            node2.setChars(chars);
                            continue;
                        }
                        node2.unlink();
                    }
                }
            }
            this.appendNode(insertNode);
            if (insertNode instanceof RefNode) {
                RefNode refNode = (RefNode)insertNode;
                refNode.setReferenceChars(ref);
                if (refIsDefined) {
                    refNode.setDefined(true);
                }
                if (!refIsBare) {
                    refNode.setTextChars(this.input.subSequence(isImage ? opener.getStartIndex() - 1 : opener.getStartIndex(), startIndex));
                } else if (!bareRef.isEmpty()) {
                    refNode.setTextOpeningMarker(bareRef.subSequence(0, 1));
                    refNode.setTextClosingMarker((BasedSequence)bareRef.endSequence(1));
                }
                insertNode.setCharsFromContent();
            } else if (insertNode instanceof InlineLinkNode) {
                InlineLinkNode inlineLinkNode = (InlineLinkNode)insertNode;
                inlineLinkNode.setUrlChars(dest);
                inlineLinkNode.setTitleChars(title);
                inlineLinkNode.setLinkOpeningMarker(linkOpener);
                inlineLinkNode.setLinkClosingMarker(linkCloser);
                inlineLinkNode.setTextChars(isImage ? this.input.subSequence(opener.getStartIndex() - 1, startIndex) : this.input.subSequence(opener.getStartIndex(), startIndex));
                if (imageUrlContent != null) {
                    ((Image)insertNode).setUrlContent(imageUrlContent);
                }
                insertNode.setCharsFromContent();
            }
            this.processDelimiters(opener.getPreviousDelimiter());
            Text toRemove = opener.getNode();
            this.removeLastBracket();
            if (linkRefProcessorMatch != null) {
                linkRefProcessorMatch.processor.updateNodeElements(this.document, insertNode);
            }
            if (insertNode instanceof Link) {
                for (Bracket bracket = this.lastBracket; bracket != null; bracket = bracket.getPrevious()) {
                    if (bracket.isImage()) continue;
                    bracket.setAllowed(false);
                }
                if (this.options.linkTextPriorityOverLinkRef || !InlineParserImpl.containsLinkRefs(insertNode, false)) {
                    InlineParserImpl.collapseLinkRefChildren(insertNode, child -> child instanceof LinkRendered || child.isTentative(), true);
                    toRemove.unlink();
                } else {
                    insertNode.unlink();
                    this.block.takeChildren(insertNode);
                    this.appendText(insertNode.baseSubSequence(((Link)insertNode).getTextClosingMarker().getStartOffset(), insertNode.getEndOffset()));
                }
            } else if (insertNode instanceof RefNode) {
                InlineParserImpl.collapseLinkRefChildren(insertNode, child -> child instanceof LinkRendered || child.isTentative(), true);
                toRemove.unlink();
            } else {
                toRemove.unlink();
            }
            return true;
        }
        this.index = startIndex;
        this.appendText(this.input.subSequence(this.index - 1, this.index));
        this.removeLastBracket();
        return true;
    }

    protected static boolean containsLinkRefs(Node node, Boolean isTentative) {
        for (Node next = node.getFirstChild(); next != null; next = next.getNext()) {
            if (!(next instanceof LinkRendered) || isTentative != null && ((LinkRendered)((Object)next)).isTentative() != isTentative.booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected static boolean containsLinkRefs(BasedSequence nodeChars, Node next, Boolean isTentative) {
        int startOffset = nodeChars.getStartOffset();
        int endOffset = nodeChars.getEndOffset();
        while (next != null) {
            if (next instanceof LinkRefDerived && (isTentative == null || ((LinkRefDerived)((Object)next)).isTentative() == isTentative.booleanValue()) && next.getStartOffset() < endOffset && next.getEndOffset() > startOffset) {
                return true;
            }
            next = next.getNext();
        }
        return false;
    }

    protected static void collapseLinkRefChildren(Node node, Function<LinkRefDerived, Boolean> isTentative, boolean trimFirstLastChild) {
        Node child = node.getFirstChild();
        boolean hadCollapse = false;
        while (child != null) {
            Node nextChild = child.getNext();
            if (child instanceof LinkRefDerived && (isTentative == null || isTentative.apply((LinkRefDerived)((Object)child)).booleanValue())) {
                InlineParserImpl.collapseLinkRefChildren(child, isTentative, false);
                child.unlink();
                TextNodeConverter list = new TextNodeConverter(child.getChars());
                list.addChildrenOf(child);
                if (nextChild != null) {
                    list.insertMergedBefore(nextChild);
                } else {
                    list.appendMergedTo(node);
                }
                hadCollapse = true;
            }
            child = nextChild;
        }
        if (hadCollapse) {
            TextNodeConverter.mergeTextNodes(node);
        }
        if (trimFirstLastChild) {
            Node lastChild;
            Node firstChild = node.getFirstChild();
            if (firstChild == (lastChild = node.getLastChild())) {
                if (firstChild != null && !(firstChild instanceof DoNotTrim)) {
                    firstChild.setChars((BasedSequence)firstChild.getChars().trim());
                }
            } else {
                if (firstChild != null && !(firstChild instanceof DoNotTrim)) {
                    firstChild.setChars((BasedSequence)firstChild.getChars().trimStart());
                }
                if (lastChild != null && !(lastChild instanceof DoNotTrim)) {
                    lastChild.setChars((BasedSequence)lastChild.getChars().trimEnd());
                }
            }
        }
    }

    @Override
    public BasedSequence parseLinkDestination() {
        BasedSequence res = this.match(this.myParsing.LINK_DESTINATION_ANGLES);
        if (res != null) {
            return res;
        }
        if (this.linkDestinationParser != null) {
            BasedSequence match = this.linkDestinationParser.parseLinkDestination(this.input, this.index);
            this.index += match.length();
            return match;
        }
        boolean spaceInUrls = this.options.spaceInLinkUrls;
        if (this.options.linksAllowMatchedParentheses) {
            BasedSequence matched = this.match(this.myParsing.LINK_DESTINATION_MATCHED_PARENS);
            if (matched != null) {
                int openCount = 0;
                int iMax = matched.length();
                for (int i = 0; i < iMax; ++i) {
                    char c = matched.charAt(i);
                    if (c == '\\') {
                        if (i + 1 >= iMax || !this.myParsing.ESCAPABLE.matcher(matched.subSequence(i + 1, i + 2)).matches()) continue;
                        ++i;
                        continue;
                    }
                    if (c == '(') {
                        ++openCount;
                        continue;
                    }
                    if (c != ')') continue;
                    if (openCount == 0) {
                        this.index -= iMax - i;
                        matched = matched.subSequence(0, i);
                        break;
                    }
                    --openCount;
                }
                return spaceInUrls ? (BasedSequence)matched.trimEnd(CharPredicate.SPACE) : matched;
            }
            return null;
        }
        BasedSequence matched = this.match(this.myParsing.LINK_DESTINATION);
        return matched != null && spaceInUrls ? (BasedSequence)matched.trimEnd(CharPredicate.SPACE) : matched;
    }

    @Override
    public BasedSequence parseLinkTitle() {
        BasedSequence title = this.match(this.myParsing.LINK_TITLE);
        return title;
    }

    @Override
    public int parseLinkLabel() {
        BasedSequence m3 = this.match(this.myParsing.LINK_LABEL);
        return m3 == null ? 0 : m3.length();
    }

    @Override
    public boolean parseAutolink() {
        BasedSequence m3 = this.match(this.myParsing.EMAIL_AUTOLINK);
        if (m3 != null) {
            MailLink node = new MailLink(m3.subSequence(0, 1), m3.subSequence(1, m3.length() - 1), m3.subSequence(m3.length() - 1, m3.length()));
            this.appendNode(node);
            return true;
        }
        m3 = this.match(this.myParsing.AUTOLINK);
        if (m3 != null) {
            AutoLink node = new AutoLink(m3.subSequence(0, 1), m3.subSequence(1, m3.length() - 1), m3.subSequence(m3.length() - 1, m3.length()));
            this.appendNode(node);
            return true;
        }
        if (this.options.wwwAutoLinkElement && (m3 = this.match(this.myParsing.WWW_AUTOLINK)) != null) {
            AutoLink node = new AutoLink(m3.subSequence(0, 1), m3.subSequence(1, m3.length() - 1), m3.subSequence(m3.length() - 1, m3.length()));
            this.appendNode(node);
            return true;
        }
        return false;
    }

    @Override
    public boolean parseHtmlInline() {
        BasedSequence m3 = this.match(this.myParsing.HTML_TAG);
        if (m3 != null) {
            HtmlInlineBase node = m3.startsWith("<!--") && m3.endsWith("-->") ? new HtmlInlineComment(m3) : new HtmlInline(m3);
            this.appendNode(node);
            return true;
        }
        return false;
    }

    @Override
    public boolean parseEntity() {
        BasedSequence m3 = this.match(this.myParsing.ENTITY_HERE);
        if (m3 != null) {
            HtmlEntity node = new HtmlEntity(m3);
            this.appendNode(node);
            return true;
        }
        return false;
    }

    protected boolean parseString() {
        int begin = this.index;
        int length = this.input.length();
        while (this.index != length && !this.specialCharacters.get(this.input.charAt(this.index))) {
            ++this.index;
        }
        if (begin != this.index) {
            this.appendText(this.input, begin, this.index);
            return true;
        }
        return false;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected DelimiterData scanDelimiters(DelimiterProcessor delimiterProcessor, char delimiterChar) {
        boolean rightFlanking;
        boolean leftFlanking;
        boolean afterIsPunctuation;
        boolean beforeIsPunctuation;
        int startIndex = this.index;
        int delimiterCount = 0;
        while (this.peek() == delimiterChar) {
            ++delimiterCount;
            ++this.index;
        }
        if (delimiterCount < delimiterProcessor.getMinLength()) {
            this.index = startIndex;
            return null;
        }
        String before = startIndex == 0 ? "\n" : String.valueOf(this.input.charAt(startIndex - 1));
        char charAfter = this.peek();
        String after = charAfter == '\u0000' ? "\n" : String.valueOf(charAfter);
        boolean beforeIsWhitespace = this.myParsing.UNICODE_WHITESPACE_CHAR.matcher(before).matches();
        boolean afterIsWhitespace = this.myParsing.UNICODE_WHITESPACE_CHAR.matcher(after).matches();
        if (this.options.inlineDelimiterDirectionalPunctuations) {
            beforeIsPunctuation = this.myParsing.PUNCTUATION_OPEN.matcher(before).matches();
            afterIsPunctuation = this.myParsing.PUNCTUATION_CLOSE.matcher(after).matches();
            leftFlanking = !afterIsWhitespace && (!afterIsPunctuation || beforeIsWhitespace || beforeIsPunctuation);
            rightFlanking = !beforeIsWhitespace && (!beforeIsPunctuation || afterIsWhitespace || afterIsPunctuation);
        } else {
            beforeIsPunctuation = this.myParsing.PUNCTUATION.matcher(before).matches();
            afterIsPunctuation = this.myParsing.PUNCTUATION.matcher(after).matches();
            leftFlanking = !afterIsWhitespace && (!afterIsPunctuation || beforeIsWhitespace || beforeIsPunctuation);
            rightFlanking = !beforeIsWhitespace && (!beforeIsPunctuation || afterIsWhitespace || afterIsPunctuation);
        }
        boolean canOpen = delimiterChar == delimiterProcessor.getOpeningCharacter() && delimiterProcessor.canBeOpener(before, after, leftFlanking, rightFlanking, beforeIsPunctuation, afterIsPunctuation, beforeIsWhitespace, afterIsWhitespace);
        boolean canClose = delimiterChar == delimiterProcessor.getClosingCharacter() && delimiterProcessor.canBeCloser(before, after, leftFlanking, rightFlanking, beforeIsPunctuation, afterIsPunctuation, beforeIsWhitespace, afterIsWhitespace);
        this.index = startIndex;
        if (canOpen || canClose || !delimiterProcessor.skipNonOpenerCloser()) {
            return new DelimiterData(delimiterCount, canOpen, canClose);
        }
        return null;
    }

    @Override
    public void processDelimiters(Delimiter stackBottom) {
        Delimiter closer;
        HashMap<Character, Delimiter> openersBottom = new HashMap<Character, Delimiter>();
        for (closer = this.lastDelimiter; closer != null && closer.getPrevious() != stackBottom; closer = closer.getPrevious()) {
        }
        while (closer != null) {
            Delimiter opener;
            char delimiterChar = closer.getDelimiterChar();
            DelimiterProcessor delimiterProcessor = this.delimiterProcessors.get(Character.valueOf(delimiterChar));
            if (!closer.canClose() || delimiterProcessor == null) {
                closer = closer.getNext();
                continue;
            }
            char openingDelimiterChar = delimiterProcessor.getOpeningCharacter();
            int useDelims = 0;
            boolean openerFound = false;
            boolean potentialOpenerFound = false;
            for (opener = closer.getPrevious(); opener != null && opener != stackBottom && opener != openersBottom.get(Character.valueOf(delimiterChar)); opener = opener.getPrevious()) {
                if (!opener.canOpen() || opener.getDelimiterChar() != openingDelimiterChar) continue;
                potentialOpenerFound = true;
                useDelims = delimiterProcessor.getDelimiterUse(opener, closer);
                if (useDelims <= 0) continue;
                openerFound = true;
                break;
            }
            if (!openerFound) {
                if (!potentialOpenerFound) {
                    openersBottom.put(Character.valueOf(delimiterChar), closer.getPrevious());
                    if (!closer.canOpen()) {
                        this.removeDelimiterKeepNode(closer);
                    }
                }
                closer = closer.getNext();
                continue;
            }
            opener.setNumDelims(opener.getNumDelims() - useDelims);
            closer.setNumDelims(closer.getNumDelims() - useDelims);
            this.removeDelimitersBetween(opener, closer);
            opener.setNumDelims(opener.getNumDelims() + useDelims);
            closer.setNumDelims(closer.getNumDelims() + useDelims);
            delimiterProcessor.process(opener, closer, useDelims);
            opener.setNumDelims(opener.getNumDelims() - useDelims);
            closer.setNumDelims(closer.getNumDelims() - useDelims);
            if (opener.getNumDelims() == 0) {
                this.removeDelimiterAndNode(opener);
            } else {
                opener.getNode().setChars(opener.getNode().getChars().subSequence(0, opener.getNumDelims()));
            }
            if (closer.getNumDelims() == 0) {
                Delimiter next = closer.getNext();
                this.removeDelimiterAndNode(closer);
                closer = next;
                continue;
            }
            BasedSequence chars = closer.getNode().getChars();
            int length = chars.length();
            closer.getNode().setChars(chars.subSequence(length - closer.getNumDelims(), length));
            closer.setIndex(closer.getIndex() + useDelims);
        }
        while (this.lastDelimiter != null && this.lastDelimiter != stackBottom) {
            this.removeDelimiterKeepNode(this.lastDelimiter);
        }
    }

    @Override
    public void removeDelimitersBetween(@NotNull Delimiter opener, @NotNull Delimiter closer) {
        Delimiter delimiter = closer.getPrevious();
        while (delimiter != null && delimiter != opener) {
            Delimiter previousDelimiter = delimiter.getPrevious();
            this.removeDelimiterKeepNode(delimiter);
            delimiter = previousDelimiter;
        }
    }

    @Override
    public void removeDelimiterAndNode(@NotNull Delimiter delim) {
        Text node = delim.getNode();
        Text previousText = delim.getPreviousNonDelimiterTextNode();
        Text nextText = delim.getNextNonDelimiterTextNode();
        if (previousText != null && nextText != null) {
            previousText.setChars(this.input.baseSubSequence(previousText.getStartOffset(), nextText.getEndOffset()));
            nextText.unlink();
        }
        node.unlink();
        this.removeDelimiter(delim);
    }

    @Override
    public void removeDelimiterKeepNode(@NotNull Delimiter delim) {
        Node node;
        DelimiterProcessor delimiterProcessor = this.delimiterProcessors.get(Character.valueOf(delim.getDelimiterChar()));
        Node node2 = node = delimiterProcessor != null ? delimiterProcessor.unmatchedDelimiterNode(this, delim) : null;
        if (node != null) {
            if (node != delim.getNode()) {
                delim.getNode().insertAfter(node);
                delim.getNode().unlink();
            }
        } else {
            node = delim.getNode();
        }
        Text previousText = delim.getPreviousNonDelimiterTextNode();
        Text nextText = delim.getNextNonDelimiterTextNode();
        if (node instanceof Text && (previousText != null || nextText != null)) {
            if (nextText != null && previousText != null) {
                node.setChars(this.input.baseSubSequence(previousText.getStartOffset(), nextText.getEndOffset()));
                previousText.unlink();
                nextText.unlink();
            } else if (previousText != null) {
                node.setChars(this.input.baseSubSequence(previousText.getStartOffset(), node.getEndOffset()));
                previousText.unlink();
            } else {
                node.setChars(this.input.baseSubSequence(node.getStartOffset(), nextText.getEndOffset()));
                nextText.unlink();
            }
        }
        this.removeDelimiter(delim);
    }

    @Override
    public void removeDelimiter(@NotNull Delimiter delim) {
        if (delim.getPrevious() != null) {
            delim.getPrevious().setNext(delim.getNext());
        }
        if (delim.getNext() == null) {
            this.lastDelimiter = delim.getPrevious();
        } else {
            delim.getNext().setPrevious(delim.getPrevious());
        }
    }

    static Map<Character, List<InlineParserExtensionFactory>> calculateInlineParserExtensions(DataHolder options, List<InlineParserExtensionFactory> extensionFactories) {
        HashMap<Character, List> extensionMap = new HashMap<Character, List>();
        for (InlineParserExtensionFactory factory : extensionFactories) {
            CharSequence chars = factory.getCharacters();
            for (int i = 0; i < chars.length(); ++i) {
                char c = chars.charAt(i);
                List list = extensionMap.computeIfAbsent(Character.valueOf(c), k -> new ArrayList());
                list.add(factory);
            }
        }
        HashMap<Character, List<InlineParserExtensionFactory>> extensions = new HashMap<Character, List<InlineParserExtensionFactory>>();
        for (Character c : extensionMap.keySet()) {
            List list = (List)extensionMap.get(c);
            List resolvedList = DependencyResolver.resolveFlatDependencies(list, null, null);
            extensions.put(c, resolvedList);
        }
        return extensions;
    }

    public static BitSet calculateDelimiterCharacters(DataHolder options, Set<Character> characters) {
        BitSet bitSet = new BitSet();
        for (Character character : characters) {
            bitSet.set(character.charValue());
        }
        return bitSet;
    }

    public static BitSet calculateSpecialCharacters(DataHolder options, BitSet delimiterCharacters) {
        BitSet bitSet = new BitSet();
        bitSet.or(delimiterCharacters);
        bitSet.set(13);
        bitSet.set(10);
        bitSet.set(96);
        bitSet.set(91);
        bitSet.set(93);
        bitSet.set(92);
        bitSet.set(33);
        bitSet.set(60);
        bitSet.set(38);
        return bitSet;
    }

    public static Map<Character, DelimiterProcessor> calculateDelimiterProcessors(DataHolder options, List<DelimiterProcessor> delimiterProcessors) {
        HashMap<Character, DelimiterProcessor> map = new HashMap<Character, DelimiterProcessor>();
        if (Parser.ASTERISK_DELIMITER_PROCESSOR.get(options).booleanValue()) {
            InlineParserImpl.addDelimiterProcessors(Collections.singletonList(new AsteriskDelimiterProcessor(Parser.STRONG_WRAPS_EMPHASIS.get(options))), map);
        }
        if (Parser.UNDERSCORE_DELIMITER_PROCESSOR.get(options).booleanValue()) {
            InlineParserImpl.addDelimiterProcessors(Collections.singletonList(new UnderscoreDelimiterProcessor(Parser.STRONG_WRAPS_EMPHASIS.get(options))), map);
        }
        InlineParserImpl.addDelimiterProcessors(delimiterProcessors, map);
        return map;
    }

    public static LinkRefProcessorData calculateLinkRefProcessors(DataHolder options, List<LinkRefProcessorFactory> linkRefProcessors) {
        if (linkRefProcessors.size() > 1) {
            int maxNestingLevel;
            ArrayList<LinkRefProcessorFactory> sortedLinkProcessors = new ArrayList<LinkRefProcessorFactory>(linkRefProcessors.size());
            sortedLinkProcessors.addAll(linkRefProcessors);
            int[] maxNestingLevelRef = new int[]{0};
            Collections.sort(sortedLinkProcessors, (p1, p2) -> {
                int lv1 = p1.getBracketNestingLevel(options);
                int lv2 = p2.getBracketNestingLevel(options);
                int maxLevel = maxNestingLevelRef[0];
                if (maxLevel < lv1) {
                    maxLevel = lv1;
                }
                if (maxLevel < lv2) {
                    maxLevel = lv2;
                }
                maxNestingLevelRef[0] = maxLevel;
                if (lv1 == lv2) {
                    if (!p1.getWantExclamationPrefix(options)) {
                        ++lv1;
                    }
                    if (!p2.getWantExclamationPrefix(options)) {
                        ++lv2;
                    }
                }
                return Integer.compare(lv1, lv2);
            });
            int maxReferenceLinkNesting = maxNestingLevel = maxNestingLevelRef[0];
            int[] nestingLookup = new int[maxNestingLevel + 1];
            maxNestingLevel = -1;
            int index = 0;
            for (LinkRefProcessorFactory linkProcessor : sortedLinkProcessors) {
                if (maxNestingLevel < linkProcessor.getBracketNestingLevel(options)) {
                    maxNestingLevel = linkProcessor.getBracketNestingLevel(options);
                    nestingLookup[maxNestingLevel] = index;
                    if (maxNestingLevel == maxReferenceLinkNesting) break;
                }
                ++index;
            }
            return new LinkRefProcessorData(sortedLinkProcessors, maxReferenceLinkNesting, nestingLookup);
        }
        if (linkRefProcessors.size() > 0) {
            int maxNesting = linkRefProcessors.get(0).getBracketNestingLevel(options);
            int[] nestingLookup = new int[maxNesting + 1];
            return new LinkRefProcessorData(linkRefProcessors, maxNesting, nestingLookup);
        }
        return new LinkRefProcessorData(linkRefProcessors, 0, new int[0]);
    }

    private static void addDelimiterProcessors(List<? extends DelimiterProcessor> delimiterProcessors, Map<Character, DelimiterProcessor> map) {
        for (DelimiterProcessor delimiterProcessor : delimiterProcessors) {
            char opening = delimiterProcessor.getOpeningCharacter();
            InlineParserImpl.addDelimiterProcessorForChar(opening, delimiterProcessor, map);
            char closing = delimiterProcessor.getClosingCharacter();
            if (opening == closing) continue;
            InlineParserImpl.addDelimiterProcessorForChar(closing, delimiterProcessor, map);
        }
    }

    private static void addDelimiterProcessorForChar(char delimiterChar, DelimiterProcessor toAdd, Map<Character, DelimiterProcessor> delimiterProcessors) {
        DelimiterProcessor existing = delimiterProcessors.put(Character.valueOf(delimiterChar), toAdd);
        if (existing != null) {
            if (existing.getClass() != toAdd.getClass()) {
                throw new IllegalArgumentException("Delimiter processor conflict with delimiter char '" + delimiterChar + "', existing " + existing.getClass().getCanonicalName() + ", added " + toAdd.getClass().getCanonicalName());
            }
            System.out.println("Delimiter processor for char '" + delimiterChar + "', added more than once " + existing.getClass().getCanonicalName());
        }
    }

    static class ReferenceProcessorMatch {
        public final LinkRefProcessor processor;
        public final BasedSequence nodeChars;
        public final boolean wantExclamation;

        public ReferenceProcessorMatch(LinkRefProcessor processor, boolean wantExclamation, BasedSequence nodeChars) {
            this.processor = processor;
            this.nodeChars = nodeChars;
            this.wantExclamation = wantExclamation;
        }
    }

    private static class DelimiterData {
        final int count;
        final boolean canClose;
        final boolean canOpen;

        DelimiterData(int count, boolean canOpen, boolean canClose) {
            this.count = count;
            this.canOpen = canOpen;
            this.canClose = canClose;
        }
    }
}

